// priority: 5

let 持久化计数器 = "kubejs_death_counters";
let 扫描半径 = 64;
let 使用白名单模式 = true;
// 格式: "生物ID": [重生所需死亡次数, 是否计算不死图腾 (可选,布尔值)]
let 生物击杀阶段阈值 = {
    "minecraft:warden": 3, // 坚守者
    "minecraft:wither": 1, // 凋灵
    "goety:wight": 3, // 孤魂尸鬼
    "goety:inferno": 3, // 狱焰
    "goety:crone": 3, // 巫婆
    "twilightforest:alpha_yeti": 3, // 雪怪首领
    "twilightforest:hydra": 3, // 九头蛇
    "twilightforest:knight_phantom": 3, // 幻影骑士
    "twilightforest:lich": 3, // 巫妖
    "twilightforest:minoshroom": 3, // 米诺菇
    "twilightforest:naga": 3, // 娜迦 
    "twilightforest:snow_queen": 3, // 冰雪女王
    "twilightforest:ur_ghast": 3, // 暮初恶魂
    "irons_spellbooks:dead_king": 1, // 死者之王
    "bosses_of_mass_destruction:void_blossom": 3, // 虚空之花
    "cataclysm:kobolediator": 3, // 骷髅狗头人将军
    "graveyard:lich": 3, // 墓园巫妖
    "illagerinvasion:invoker": 3, // 祈灵师
    "goety:skull_lord": 3, // 骷髅领主
    "goety:bone_lord": 3, // 骨骼领主
    "goety:wither_necromancer": 3, // 凋零死灵法师
    "mowziesmobs:ferrous_wroughtnaut": 3, // 钢铁守护者
    "mowziesmobs:umvuthi": 3, // 太阳鸟
    "bosses_of_mass_destruction:lich": 3, // 暗夜巫妖
    "mowziesmobs:frostmaw": 3, // 霜冻巨兽
    "aquamirae:maze_mother": 3, // 迷宫之母
    "aquamirae:captain_cornelia": 3, // 船长科妮莉亚亡灵
    "cataclysm:ender_guardian": 3, // 末影守卫者
    "cataclysm:netherite_monstrosity": 3, // 下界合金巨兽
    "cataclysm:the_harbinger": 3, // 先驱者
    "cataclysm:the_leviathan": 3, // 利维坦
    "cataclysm:ancient_remnant": 3, // 远古遗魂
    "cataclysm:maledictus": 3, // 咒翼灵骸
    "goety:vizier": 3, // 宰相
    "goety:vizier_clone": 3, // 宰相之影
    "bosses_of_mass_destruction:obsidilith": 3, // 黑曜石柱
    "minecraft:ender_dragon": 3, // 末影龙
    "alexsmobs:void_worm": 5, // 虚空蠕虫
    "cataclysm:ignis": 3, // 焰魔
    "goety:apostle": 7 // 使徒
};

let 黑名单生物列表 = ["minecraft:zombie", "minecraft:skeleton", "minecraft:creeper", "minecraft:spider", "minecraft:item"];
let 黑名单模式默认阈值 = 5;
let 全局默认计算不死图腾 = true;
let 黑名单模式计算不死图腾 = true;

let 增加生物计数并检查重生 = (p, s) => {
    let 世界 = p.level;
    let sDATA = s.persistentData;
    let 计数器对象 = sDATA.getCompound(持久化计数器);
    
    if (计数器对象.isEmpty()) return;

    let 附近实体列表 = 世界.getEntitiesWithin(p.getBoundingBox().inflate(扫描半径));
    let 需要重生的生物列表 = [];
    let 有计数更新 = false;
    
    附近实体列表.forEach(附近生物 => {
        let 当前生物UUID = 附近生物.uuid.toString();
        
        if (计数器对象.contains(当前生物UUID)) {
            let 当前生物ID = 附近生物.type;
            let 该生物重置阈值;

            if (生物击杀阶段阈值.hasOwnProperty(当前生物ID)) {
                let 配置 = 生物击杀阶段阈值[当前生物ID];
                该生物重置阈值 = Array.isArray(配置) ? 配置[0] : 配置;
            } else if (!使用白名单模式) {
                该生物重置阈值 = 黑名单模式默认阈值;
            } else {
                return;
            }
            有计数更新 = true;
            let 当前计数 = 计数器对象.getInt(当前生物UUID);
            let 新计数 = 当前计数 + 1;
            计数器对象.putInt(当前生物UUID, 新计数);
            
            if (新计数 >= 该生物重置阈值) {
                需要重生的生物列表.push(附近生物);
            }
        }
    });
    
    if (!有计数更新) return;

    需要重生的生物列表.forEach(待重生生物 => {
        let 待重生生物UUID = 待重生生物.uuid.toString();
        if (计数器对象.contains(待重生生物UUID)) {
            计数器对象.remove(待重生生物UUID);
            let 生成X = 待重生生物.x, 生成Y = 待重生生物.y, 生成Z = 待重生生物.z;
            let 生成偏航角 = 待重生生物.yRot, 生成俯仰角 = 待重生生物.xRot, 头部偏航角 = 待重生生物.yHeadRot;

            if (待重生生物 && !待重生生物.isRemoved()) 待重生生物.discard();

            let 新生物 = 世界.createEntity(待重生生物.type);
            if (新生物) {
                新生物.setPos(生成X, 生成Y, 生成Z);
                try { 新生物.setYRot(生成偏航角); } catch (e) {}
                try { 新生物.setXRot(生成俯仰角); } catch (e) {}
                try { 新生物.setYHeadRot(头部偏航角); } catch (e) {}
                新生物.spawn();
                s.tell(Component.translate("kubejs.message.death_limit.respawn", Text.aqua(新生物.displayName)));
            }
        }
    });
    sDATA.put(持久化计数器, 计数器对象);
};

// [阶段一：标记生物]
EntityEvents.hurt(事件 => {
    if (事件.entity.level.isClientSide()) return;
    let { entity: 受击生物, source: 伤害来源, server: s } = 事件;
    let 攻击者 = 伤害来源.actual;
    if (!攻击者 || !攻击者.isPlayer()) return;

    let 受击生物ID = 受击生物.type;
    let 实体UUID = 受击生物.uuid.toString();
    
    let 是否应该追踪 = false;
    if (使用白名单模式) {
        if (生物击杀阶段阈值.hasOwnProperty(受击生物ID)) 是否应该追踪 = true;
    } else {
        if (!黑名单生物列表.includes(受击生物ID)) 是否应该追踪 = true;
    }

    if (!是否应该追踪) return;
    
    let sDATA = s.persistentData;
    let 计数器对象 = sDATA.getCompound(持久化计数器);
    if (计数器对象.contains(实体UUID)) return;
    
    计数器对象.putInt(实体UUID, 0);
    sDATA.put(持久化计数器, 计数器对象);
});

// [阶段二A：真正的死亡]
NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingDeathEvent"), 事件 => {
    let { entity: 死者 } = 事件;
    if (死者.level.isClientSide()) return;
    
    if (死者.isPlayer()) {
        let s = 死者.server;
        增加生物计数并检查重生(死者, s);
    } 
    else {
        let 死亡生物UUID = 死者.uuid.toString();
        let s = 死者.server;
        let sDATA = s.persistentData;
        let 计数器对象 = sDATA.getCompound(持久化计数器);
        
        if (计数器对象.contains(死亡生物UUID)) {
            计数器对象.remove(死亡生物UUID);
            sDATA.put(持久化计数器, 计数器对象);
        }
    }
});

// [阶段二B：使用不死图腾]
NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingUseTotemEvent"), 事件 => {
    let { entity: 使用者 } = 事件;
    if (!使用者.isPlayer()) return;
    
    let s = 使用者.server;
    let 是否应该为所有生物计数 = false;
    
    if (使用白名单模式) {
        if(全局默认计算不死图腾) {
            是否应该为所有生物计数 = true;
        }
    } else {
        if (黑名单模式计算不死图腾) {
            是否应该为所有生物计数 = true;
        }
    }

    if (是否应该为所有生物计数) {
        增加生物计数并检查重生(使用者, s);
    }
});